<?php
/**
 * @copyright	Copyright (C) 2005 - 2010 Michael Richey. All rights reserved.
 * @license		GNU General Public License version 3; see LICENSE.txt
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');
jimport('joomla.form.helper');

class JFormFieldColor extends JFormFieldList
{
	public $type = 'Color';

	protected function getInput()
	{
		$doc = &JFactory::getDocument();
		$assetpath = JURI::root(true).DS.'media'.DS.'mod_coolclock'.DS.'assets'.DS.'color'.DS;
		$doc = &JFactory::getDocument();
		$doc->addScript($assetpath.'mooRainbow.js');
		$doc->addStyleSheet($assetpath.'mooRainbow.css');
		$initcolors="window.addEvent('domready',function(){\n\tnew MooRainbow('".$this->id."',{\n\t\tid: 'my".$this->id."',\n\t\timgPath: '".$assetpath.'images'.DS."',\n\t\twheel: true,\n\t\tonChange: function(color){\n\t\t\tdocument.id('".$this->id."').value = color.hex;\n\t\t},\n\t\tonComplete: function(color){\n\t\t\tdocument.id('".$this->id."').value = color.hex;\n\t\t}\n\t});\n});";
		$doc->addScriptDeclaration($initcolors);

		// Initialize variables.
		$html = array();
		$attr = '';

		// Initialize some field attributes.
		$attr .= $this->element['class'] ? ' class="inputbox '.(string) $this->element['class'].'"' : ' class="inputbox"';
		$attr .= ((string) $this->element['readonly'] == 'true') ? ' readonly="readonly"' : '';
		$attr .= ((string) $this->element['disabled'] == 'true') ? ' disabled="disabled"' : '';
		$attr .= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';

		// Initialize JavaScript field attributes.
		$attr .= $this->element['onchange'] ? ' onchange="'.(string) $this->element['onchange'].'"' : '';

		// Build the input for the color box.
		$html = '<input type="text" name="'.$this->name.'" id="'.$this->id.'"' .
				' value="'.htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8').'"'.$attr.'/>';
		return $html;
	}
}
