<?php

/*

 * @package Joomla 1.5

 * @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php

 *

 * @component Phoca Gallery

 * @copyright Copyright (C) Jan Pavelka www.phoca.cz

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL

 */

defined( '_JEXEC' ) or die( 'Restricted access' );



jimport('joomla.html.pagination');

class PhocaGalleryPaginationCategory extends JPagination

{

	function getLimitBox() {

		$app	= JFactory::getApplication();

		

		$paramsC 			= JComponentHelper::getParams('com_phocagallery') ;

		$pagination 		= $paramsC->get( 'pagination_category', '5,10,15,20,50' );

		$paginationArray	= explode( ',', $pagination );

		

		// Initialize variables

		$limits = array ();



		foreach ($paginationArray as $paginationValue) {

			$limits[] = JHTML::_('select.option', $paginationValue);

		}

		$limits[] = JHTML::_('select.option', '0', JText::_('COM_PHOCAGALLERY_ALL'));



		$selected = $this->_viewall ? 0 : $this->limit;



		// Build the select list

		if ($app->isAdmin()) {

			$html = JHTML::_('select.genericlist',  $limits, 'limit', 'class="inputbox" size="1" onchange="submitform();"', 'value', 'text', $selected);

		} else {

			$html = JHTML::_('select.genericlist',  $limits, 'limit', 'class="inputbox" size="1" onchange="this.form.submit()"', 'value', 'text', $selected);

		}

		return $html;

	}

}

?>